/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.watchers.Watcher;

class SummoningTrapWatcher
extends Watcher {
    private Set<UUID> players = new HashSet<UUID>();

    public SummoningTrapWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.COUNTERED) {
            StackObject counteredSpell = game.getStack().getStackObject(event.getTargetId());
            if (counteredSpell == null) {
                counteredSpell = (StackObject)game.getLastKnownInformation(event.getTargetId(), Zone.STACK);
            }
            if (counteredSpell instanceof Spell && !this.players.contains(counteredSpell.getControllerId()) && counteredSpell.isCreature(game)) {
                StackObject counteringStackObject = game.getStack().getStackObject(event.getSourceId());
                if (counteringStackObject == null) {
                    counteringStackObject = (StackObject)game.getLastKnownInformation(event.getSourceId(), Zone.STACK);
                }
                if (counteringStackObject != null && game.getOpponents(counteredSpell.getControllerId()).contains(counteringStackObject.getControllerId())) {
                    this.players.add(counteredSpell.getControllerId());
                }
            }
        }
    }

    public boolean creatureSpellOfPlayerWasCountered(UUID playerId) {
        return this.players.contains(playerId);
    }

    public void reset() {
        super.reset();
        this.players.clear();
    }
}

