/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class SunbirdsInvocationEffect
extends OneShotEffect {
    SunbirdsInvocationEffect() {
        super(Outcome.PutCardInPlay);
        this.setText("reveal the top X cards of your library, where X is that spell's mana value. You may cast a spell with mana value X or less from among cards revealed this way without paying its mana cost. Put the rest on the bottom of your library in a random order.");
    }

    private SunbirdsInvocationEffect(SunbirdsInvocationEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        int xValue = spell.getManaValue();
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, xValue));
        if (cards.isEmpty()) {
            return true;
        }
        controller.revealCards(source, (Cards)cards, game);
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xValue + 1));
        CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)cards, (FilterCard)filter);
        cards.retainZone(Zone.LIBRARY, game);
        controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }

    public SunbirdsInvocationEffect copy() {
        return new SunbirdsInvocationEffect(this);
    }
}

