/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.Card;
import mage.cards.s.SuperiorSpiderManCopyApplier;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SuperiorSpiderManCopyEffect
extends OneShotEffect {
    SuperiorSpiderManCopyEffect() {
        super(Outcome.Copy);
        this.staticText = "as a copy of any creature card in a graveyard, except his name is Superior Spider-Man and he's a 4/4 Spider Human Hero in addition to his other types. When you do, exile that card.";
    }

    private SuperiorSpiderManCopyEffect(SuperiorSpiderManCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)new FilterCreatureCard("creature card in a graveyard"));
            target.withNotTarget(true);
            if (target.canChoose(source.getControllerId(), source, game)) {
                player.choose(this.outcome, (Target)target, source, game);
                Card copyFromCard = game.getCard(target.getFirstTarget());
                if (copyFromCard != null) {
                    PermanentCard newBluePrint = new PermanentCard(copyFromCard, source.getControllerId(), game);
                    newBluePrint.assignNewId();
                    SuperiorSpiderManCopyApplier applier = new SuperiorSpiderManCopyApplier();
                    applier.apply(game, (MageObject)newBluePrint, source, source.getSourceId());
                    CopyEffect copyEffect = new CopyEffect(Duration.Custom, (MageObject)newBluePrint, source.getSourceId());
                    game.addEffect((ContinuousEffect)copyEffect, source);
                    ReflexiveTriggeredAbility triggeredAbility = new ReflexiveTriggeredAbility((Effect)new ExileTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(copyFromCard.getId())), false);
                    game.fireReflexiveTriggeredAbility(triggeredAbility, source);
                }
            }
            return true;
        }
        return false;
    }

    public SuperiorSpiderManCopyEffect copy() {
        return new SuperiorSpiderManCopyEffect(this);
    }
}

