/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.PreventDamageToControllerEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;

public class SuppressorSkyguard
extends CardImpl {
    public SuppressorSkyguard(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{W}{U}");
        this.addSubType(new SubType[]{SubType.HUMAN});
        this.addSubType(new SubType[]{SubType.KNIGHT});
        this.power = new MageInt(2);
        this.toughness = new MageInt(4);
        this.addAbility((Ability)FlyingAbility.getInstance());
        this.addAbility((Ability)new SuppressorSkyguardTriggerAttackYou());
    }

    public SuppressorSkyguard(SuppressorSkyguard card) {
        super((CardImpl)card);
    }

    public SuppressorSkyguard copy() {
        return new SuppressorSkyguard(this);
    }

    class SuppressorSkyguardTriggerAttackYou
    extends TriggeredAbilityImpl {
        SuppressorSkyguardTriggerAttackYou() {
            super(Zone.BATTLEFIELD, (Effect)new PreventDamageToControllerEffect(Duration.EndOfCombat, true, false, Integer.MAX_VALUE), false);
            this.setTriggerPhrase("whenever a player attacks you, ");
        }

        private SuppressorSkyguardTriggerAttackYou(SuppressorSkyguardTriggerAttackYou ability) {
            super((TriggeredAbilityImpl)ability);
        }

        public SuppressorSkyguardTriggerAttackYou copy() {
            return new SuppressorSkyguardTriggerAttackYou(this);
        }

        public boolean checkEventType(GameEvent event, Game game) {
            return event.getType() == GameEvent.EventType.DEFENDER_ATTACKED;
        }

        public boolean checkTrigger(GameEvent event, Game game) {
            return this.getControllerId().equals(event.getTargetId());
        }

        public boolean checkInterveningIfClause(Game game) {
            UUID activePlayerId = game.getActivePlayerId();
            Set opponents = game.getOpponents(activePlayerId);
            game.getCombat().getGroups().stream().map(CombatGroup::getDefenderId).filter(Objects::nonNull).distinct().forEach(opponents::remove);
            return !opponents.isEmpty();
        }

        public String getRule() {
            return "Whenever a player attacks you, if that player has another opponent who isn't being attacked, prevent all combat damage that would be dealt to you this combat.";
        }
    }
}

