/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class SurpriseDeploymentEffect
extends OneShotEffect {
    private static final String choiceText = "Put a nonwhite creature card from your hand onto the battlefield?";
    private static final FilterCreatureCard filter = new FilterCreatureCard();

    public SurpriseDeploymentEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may put a nonwhite creature card from your hand onto the battlefield. At the beginning of the next end step, return that creature to your hand";
    }

    private SurpriseDeploymentEffect(SurpriseDeploymentEffect effect) {
        super((OneShotEffect)effect);
    }

    public SurpriseDeploymentEffect copy() {
        return new SurpriseDeploymentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetCardInHand target;
            if (controller.chooseUse(Outcome.PutCreatureInPlay, choiceText, source, game) && controller.choose(Outcome.PutCreatureInPlay, (Target)(target = new TargetCardInHand((FilterCard)filter)), source, game)) {
                Permanent permanent;
                Card card = game.getCard(target.getFirstTarget());
                if (card != null && controller.moveCards(card, Zone.BATTLEFIELD, source, game) && (permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) != null) {
                    ReturnToHandTargetEffect effect = new ReturnToHandTargetEffect();
                    effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                    AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect);
                    game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.not((Predicate)new ColorPredicate(ObjectColor.WHITE)));
    }
}

