/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.AmassEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SurroundedByOrcsEffect
extends OneShotEffect {
    SurroundedByOrcsEffect() {
        super(Outcome.Benefit);
        this.staticText = "amass Orcs 3, then target player mills X cards, where X is the amassed Army's power";
    }

    private SurroundedByOrcsEffect(SurroundedByOrcsEffect effect) {
        super((OneShotEffect)effect);
    }

    public SurroundedByOrcsEffect copy() {
        return new SurroundedByOrcsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = AmassEffect.doAmass((int)3, (SubType)SubType.ORC, (Game)game, (Ability)source);
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || player == null) {
            return false;
        }
        game.processAction();
        player.millCards(permanent.getPower().getValue(), source, game);
        return true;
    }
}

