/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetAnyTarget;

class SurtlandFlingerEffect
extends OneShotEffect {
    private static final String rule = "{this} deals damage equal to the sacrificed creature's power to any target. If the sacrificed creature was a Giant, {this} deals twice that much damage instead.";

    SurtlandFlingerEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice another creature. When you do, {this} deals damage equal to the sacrificed creature's power to any target. If the sacrificed creature was a Giant, {this} deals twice that much damage instead.";
    }

    private SurtlandFlingerEffect(SurtlandFlingerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SurtlandFlingerEffect copy() {
        return new SurtlandFlingerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE, true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int power = permanent.getPower().getValue();
        if (permanent.hasSubtype(SubType.GIANT, game)) {
            power *= 2;
        }
        power = Math.max(power, 0);
        if (!permanent.sacrifice(source, game)) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(power), false, rule);
        ability.addTarget((Target)new TargetAnyTarget());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

