/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandPermanent;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class SurveyorsScopeEffect
extends OneShotEffect {
    SurveyorsScopeEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "Search your library for up to X basic land cards, where X is the number of players who control at least two more lands than you. Put those cards onto the battlefield, then shuffle";
    }

    private SurveyorsScopeEffect(SurveyorsScopeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SurveyorsScopeEffect copy() {
        return new SurveyorsScopeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int numberOfLands = 0;
            int ownLands = game.getBattlefield().countAll((FilterPermanent)new FilterLandPermanent(), controller.getId(), game);
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                if (playerId.equals(controller.getId()) || game.getBattlefield().countAll((FilterPermanent)new FilterLandPermanent(), playerId, game) <= ownLands + 1) continue;
                ++numberOfLands;
            }
            game.informPlayers("Surveyor's Scope: X = " + numberOfLands);
            if (numberOfLands < 1) {
                controller.shuffleLibrary(source, game);
                return true;
            }
            return new SearchLibraryPutInPlayEffect(new TargetCardInLibrary(0, numberOfLands, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND)).apply(game, source);
        }
        return false;
    }
}

