/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.SuspendAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SuspendEffect
extends OneShotEffect {
    SuspendEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target creature and put two time counters on it. If it doesn't have suspend, it gains suspend";
    }

    private SuspendEffect(SuspendEffect effect) {
        super((OneShotEffect)effect);
    }

    public SuspendEffect copy() {
        return new SuspendEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller == null || permanent == null) {
            return false;
        }
        Card card = permanent.getMainCard();
        return controller.moveCards((Card)permanent, Zone.EXILED, source, game) && game.getState().getZone(card.getId()) == Zone.EXILED && SuspendAbility.addTimeCountersAndSuspend((Card)card, (int)3, (Ability)source, (Game)game);
    }
}

