/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class SwoopingPteranodonDamageEffect
extends OneShotEffect {
    private final int damage;

    public SwoopingPteranodonDamageEffect(int damage) {
        super(Outcome.Damage);
        this.damage = damage;
    }

    protected SwoopingPteranodonDamageEffect(SwoopingPteranodonDamageEffect effect) {
        super((OneShotEffect)effect);
        this.damage = effect.damage;
    }

    public boolean apply(Game game, Ability source) {
        Permanent damagedPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent damagingPermanent = game.getPermanent(((Target)source.getTargets().get(0)).getFirstTarget());
        if (damagedPermanent == null || damagingPermanent == null) {
            return false;
        }
        damagedPermanent.damage(this.damage, damagingPermanent.getId(), source, game, false, true);
        return true;
    }

    public SwoopingPteranodonDamageEffect copy() {
        return new SwoopingPteranodonDamageEffect(this);
    }
}

