/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class SwordOfHearthAndHomeEffect
extends OneShotEffect {
    SwordOfHearthAndHomeEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one target creature you own, then search your library for a basic land card. Put both cards onto the battlefield under your control, then shuffle";
    }

    private SwordOfHearthAndHomeEffect(SwordOfHearthAndHomeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SwordOfHearthAndHomeEffect copy() {
        return new SwordOfHearthAndHomeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            player.moveCards((Card)permanent, Zone.EXILED, source, game);
            cards.add((Card)permanent);
        }
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
        player.searchLibrary(target, source, game);
        cards.add(player.getLibrary().getCard(target.getFirstTarget(), game));
        player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }
}

