/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SwordOfKaldraTriggeredAbility
extends TriggeredAbilityImpl {
    public SwordOfKaldraTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ExileTargetEffect("exile that creature. (Exile it only if it's still on the battlefield.)"), false);
        this.setTriggerPhrase("Whenever equipped creature deals damage to a creature, ");
    }

    private SwordOfKaldraTriggeredAbility(SwordOfKaldraTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SwordOfKaldraTriggeredAbility copy() {
        return new SwordOfKaldraTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent equipment = game.getPermanent(this.getSourceId());
        if (equipment != null && equipment.getAttachedTo() != null && event.getSourceId().equals(equipment.getAttachedTo())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
            return true;
        }
        return false;
    }
}

