/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;

class SwordOfOnceAndFutureReplacementEffect
extends ReplacementEffectImpl {
    private final MageObjectReference mor;

    SwordOfOnceAndFutureReplacementEffect(Card card, Game game) {
        super(Duration.EndOfTurn, Outcome.Exile);
        this.mor = new MageObjectReference((MageObject)card.getMainCard(), game);
    }

    private SwordOfOnceAndFutureReplacementEffect(SwordOfOnceAndFutureReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.mor = effect.mor;
    }

    public SwordOfOnceAndFutureReplacementEffect copy() {
        return new SwordOfOnceAndFutureReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = this.mor.getCard(game);
        return controller != null && card != null && controller.moveCards(card, Zone.EXILED, source, game);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getToZone() == Zone.GRAVEYARD && zEvent.getTargetId().equals(this.mor.getSourceId());
    }
}

