/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CardsInControllerHandCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.cards.s.SwordOfWarAndPeaceDamageEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SwordOfWarAndPeaceAbility
extends TriggeredAbilityImpl {
    public SwordOfWarAndPeaceAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SwordOfWarAndPeaceDamageEffect());
        this.addEffect((Effect)new GainLifeEffect((DynamicValue)CardsInControllerHandCount.ANY));
    }

    private SwordOfWarAndPeaceAbility(SwordOfWarAndPeaceAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SwordOfWarAndPeaceAbility copy() {
        return new SwordOfWarAndPeaceAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent damageSource = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (damageEvent.isCombatDamage() && damageSource != null && damageSource.getAttachments().contains(this.getSourceId())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever equipped creature deals combat damage to a player, {this} deals damage to that player equal to the number of cards in their hand and you gain 1 life for each card in your hand.";
    }
}

