/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class SwornDefenderEffect
extends OneShotEffect {
    SwornDefenderEffect() {
        super(Outcome.Detriment);
        this.staticText = "{this}'s power becomes the toughness of target creature blocking or being blocked by {this} minus 1 until end of turn, and {this}'s toughness becomes 1 plus the power of that creature until end of turn";
    }

    private SwornDefenderEffect(SwornDefenderEffect effect) {
        super((OneShotEffect)effect);
    }

    public SwornDefenderEffect copy() {
        return new SwornDefenderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetPermanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller != null && targetPermanent != null) {
            int newPower = CardUtil.overflowDec((int)targetPermanent.getToughness().getValue(), (int)1);
            int newToughness = CardUtil.overflowInc((int)targetPermanent.getPower().getValue(), (int)1);
            game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(newPower, newToughness, Duration.EndOfTurn), source);
            return true;
        }
        return false;
    }
}

