/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.GetEnergyCountersControllerEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class SynthEradicatorEffect
extends OneShotEffect {
    SynthEradicatorEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. You may get {E}{E}. If you don't, you may play that card this turn.";
    }

    private SynthEradicatorEffect(SynthEradicatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public SynthEradicatorEffect copy() {
        return new SynthEradicatorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean choice;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        String mainMessage = "You may get {E}{E}";
        String messageToPlay = "do nothing";
        boolean exiled = false;
        if (card != null) {
            controller.moveCardsToExile(card, source, game, true, null, "");
            if (game.getState().getZone(card.getId()) == Zone.EXILED) {
                mainMessage = mainMessage + ". If you don't, you may play " + card.getLogName() + " until end of turn.";
                messageToPlay = "you may play " + card.getName() + " until end of turn";
                exiled = true;
            }
        }
        if (choice = controller.chooseUse(Outcome.Benefit, mainMessage, "", "get two energy counters", messageToPlay, source, game)) {
            new GetEnergyCountersControllerEffect(2).apply(game, source);
        } else if (exiled) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)false);
        }
        return true;
    }
}

