/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterSpell;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetSpell;

class SynthesisPodCost
extends CostImpl {
    private static final FilterSpell filter = new FilterSpell("a spell you control");
    private Integer exiledSpellManaValue = null;

    SynthesisPodCost() {
        TargetSpell target = new TargetSpell(filter);
        target.withNotTarget(true);
        this.addTarget((Target)target);
        this.text = "Exile a spell you control";
    }

    private SynthesisPodCost(SynthesisPodCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            return false;
        }
        player.chooseTarget(Outcome.Exile, (Target)this.getTargets().get(0), source, game);
        Spell spell = game.getSpell(this.getTargets().getFirstTarget());
        if (spell == null) {
            return false;
        }
        String spellName = spell.getName();
        this.exiledSpellManaValue = spell.getManaValue();
        player.moveCards(spell.getCard(), Zone.EXILED, source, game);
        this.paid = true;
        game.informPlayers(player.getLogName() + " exiles " + spellName + " (as costs)");
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.canChooseOrAlreadyChosen(ability, source, controllerId, game);
    }

    public SynthesisPodCost copy() {
        return new SynthesisPodCost(this);
    }

    public Integer getExiledSpellManaValue() {
        return this.exiledSpellManaValue;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

