/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;

class SyphonSoulEffect
extends OneShotEffect {
    public SyphonSoulEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 2 damage to each other player. You gain life equal to the damage dealt this way";
    }

    private SyphonSoulEffect(SyphonSoulEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int damageDealt = 0;
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            if (playerId.equals(source.getControllerId())) continue;
            damageDealt += game.getPlayer(playerId).damage(2, source.getSourceId(), source, game);
        }
        if (damageDealt > 0) {
            game.getPlayer(source.getControllerId()).gainLife(damageDealt, game, source);
        }
        return true;
    }

    public SyphonSoulEffect copy() {
        return new SyphonSoulEffect(this);
    }
}

