/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileTopXMayPlayUntilEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class SyrCarahTheBoldTriggeredAbility
extends TriggeredAbilityImpl {
    SyrCarahTheBoldTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ExileTopXMayPlayUntilEffect(1, Duration.EndOfTurn), false);
    }

    private SyrCarahTheBoldTriggeredAbility(SyrCarahTheBoldTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SyrCarahTheBoldTriggeredAbility copy() {
        return new SyrCarahTheBoldTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getSourceId().equals(this.getSourceId())) {
            return true;
        }
        Spell spell = game.getSpellOrLKIStack(event.getSourceId());
        return spell != null && spell.isInstantOrSorcery(game) && spell.isControlledBy(this.getControllerId());
    }

    public String getRule() {
        return "Whenever {this} or an instant or sorcery spell you control deals damage to a player, exile the top card of your library. You may play that card this turn.";
    }
}

