/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.cards.Card;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class SyrKonradTheGrimTriggeredAbility
extends TriggeredAbilityImpl {
    SyrKonradTheGrimTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamagePlayersEffect(1, TargetController.OPPONENT));
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private SyrKonradTheGrimTriggeredAbility(SyrKonradTheGrimTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SyrKonradTheGrimTriggeredAbility copy() {
        return new SyrKonradTheGrimTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && zEvent.getTarget() != null && !zEvent.getTargetId().equals(this.getSourceId()) && zEvent.getTarget().isCreature(game)) {
            return true;
        }
        Card card = game.getCard(zEvent.getTargetId());
        if (card == null || !card.isCreature(game)) {
            return false;
        }
        if (zEvent.getToZone() == Zone.GRAVEYARD && zEvent.getFromZone() != Zone.BATTLEFIELD) {
            return true;
        }
        return zEvent.getFromZone() == Zone.GRAVEYARD && card.isOwnedBy(this.getControllerId());
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }

    public String getRule() {
        return "Whenever another creature dies, or a creature card is put into a graveyard from anywhere other than the battlefield, or a creature card leaves your graveyard, {this} deals 1 damage to each opponent.";
    }
}

