/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SyrixCarrierOfTheFlameCastEffect
extends OneShotEffect {
    SyrixCarrierOfTheFlameCastEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may cast {this} from your graveyard";
    }

    private SyrixCarrierOfTheFlameCastEffect(SyrixCarrierOfTheFlameCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = game.getCard(source.getSourceId());
        if (card == null) {
            return false;
        }
        if (controller.chooseUse(Outcome.Benefit, "Cast " + card.getIdName() + " from your graveyard?", source, game)) {
            game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
            controller.cast(controller.chooseAbilityForCast(card, game, false), game, false, new ApprovingObject(source, game));
            game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
        }
        return true;
    }

    public SyrixCarrierOfTheFlameCastEffect copy() {
        return new SyrixCarrierOfTheFlameCastEffect(this);
    }
}

