/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.DamagePlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SzadekLordOfSecretsEffect
extends ReplacementEffectImpl {
    SzadekLordOfSecretsEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If {this} would deal combat damage to a player, instead put that many +1/+1 counters on {this} and that player mills that many cards";
    }

    private SzadekLordOfSecretsEffect(SzadekLordOfSecretsEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        DamagePlayerEvent damageEvent = (DamagePlayerEvent)event;
        Player damagedPlayer = game.getPlayer(damageEvent.getTargetId());
        if (damageEvent.isCombatDamage() && (permanent = game.getPermanent(source.getSourceId())) != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(damageEvent.getAmount()), source.getControllerId(), source, game);
            if (damagedPlayer != null) {
                damagedPlayer.millCards(damageEvent.getAmount(), source, game);
            }
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        DamagePlayerEvent damageEvent;
        return event.getSourceId().equals(source.getSourceId()) && (damageEvent = (DamagePlayerEvent)event).isCombatDamage();
    }

    public SzadekLordOfSecretsEffect copy() {
        return new SzadekLordOfSecretsEffect(this);
    }
}

