/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class WidespreadPanicEffect
extends OneShotEffect {
    WidespreadPanicEffect() {
        super(Outcome.Detriment);
        this.staticText = "each player puts a card from their hand on top of their library";
    }

    private WidespreadPanicEffect(WidespreadPanicEffect effect) {
        super((OneShotEffect)effect);
    }

    public WidespreadPanicEffect copy() {
        return new WidespreadPanicEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || player.getHand().isEmpty()) continue;
                TargetCardInHand target = new TargetCardInHand().withChooseHint("to put on top of your library");
                player.choose(Outcome.Detriment, (Target)target, source, game);
                Card card = player.getHand().get(target.getFirstTarget(), game);
                if (card == null) continue;
                player.moveCardToLibraryWithInfo(card, source, game, Zone.HAND, true, false);
            }
            return true;
        }
        return false;
    }
}

