/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.watchers.common.PlayerLostLifeWatcher;

enum AllPlayersLostLifeCount implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        return this.calculate(game, sourceAbility.getControllerId());
    }

    public int calculate(Game game, UUID controllerId) {
        PlayerLostLifeWatcher watcher = (PlayerLostLifeWatcher)game.getState().getWatcher(PlayerLostLifeWatcher.class);
        if (watcher != null) {
            int amountLifeLost = 0;
            for (UUID playerId : game.getState().getPlayersInRange(controllerId, game)) {
                amountLifeLost += watcher.getLifeLost(playerId);
            }
            return amountLifeLost;
        }
        return 0;
    }

    public DynamicValue copy() {
        return instance;
    }

    public String toString() {
        return "X";
    }

    public String getMessage() {
        return "the total life lost by all players this turn";
    }
}

