/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.AttacksIfAbleTargetPlayerSourceEffect;
import mage.cards.t.AttackedLastCombatWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.RandomUtil;

class AttackIfAbleTargetRandoOpponentSourceEffect
extends OneShotEffect {
    AttackIfAbleTargetRandoOpponentSourceEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose an opponent at random that {this} didn't attack during your last combat. {this} attacks that player this combat if able. If you can't choose an opponent this way, tap {this}";
    }

    private AttackIfAbleTargetRandoOpponentSourceEffect(AttackIfAbleTargetRandoOpponentSourceEffect effect) {
        super((OneShotEffect)effect);
    }

    public AttackIfAbleTargetRandoOpponentSourceEffect copy() {
        return new AttackIfAbleTargetRandoOpponentSourceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        AttackedLastCombatWatcher watcher = (AttackedLastCombatWatcher)game.getState().getWatcher(AttackedLastCombatWatcher.class);
        if (controller != null && sourcePermanent != null && watcher != null) {
            ArrayList<UUID> opponents = new ArrayList<UUID>();
            Map<MageObjectReference, UUID> attackedPlayers = watcher.getAttackedLastCombatPlayers(source.getControllerId());
            MageObjectReference mor = new MageObjectReference((MageObject)sourcePermanent, game);
            if (attackedPlayers == null) {
                opponents.addAll(game.getOpponents(controller.getId()));
            } else {
                for (UUID opp : game.getOpponents(controller.getId())) {
                    if (opp.equals(attackedPlayers.getOrDefault(mor, null))) continue;
                    opponents.add(opp);
                }
            }
            if (!opponents.isEmpty()) {
                Player opponent = game.getPlayer((UUID)opponents.get(RandomUtil.nextInt((int)opponents.size())));
                if (opponent != null) {
                    AttacksIfAbleTargetPlayerSourceEffect effect = new AttacksIfAbleTargetPlayerSourceEffect();
                    effect.setTargetPointer((TargetPointer)new FixedTarget(opponent.getId()));
                    game.addEffect((ContinuousEffect)effect, source);
                    game.informPlayers(sourcePermanent.getLogName() + " has to attack " + opponent.getLogName() + ".");
                }
            } else {
                game.informPlayers(sourcePermanent.getLogName() + " can't attack an opponent it didn't attack last combat.");
                sourcePermanent.tap(source, game);
            }
            return true;
        }
        return false;
    }
}

