/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class AttackedLastCombatWatcher
extends Watcher {
    private final Map<UUID, Map<MageObjectReference, UUID>> attackedLastCombatPlayers = new HashMap<UUID, Map<MageObjectReference, UUID>>();

    public AttackedLastCombatWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DECLARE_ATTACKERS_STEP_PRE) {
            this.attackedLastCombatPlayers.remove(game.getCombat().getAttackingPlayerId());
        }
        if (event.getType() == GameEvent.EventType.ATTACKER_DECLARED) {
            HashMap<MageObjectReference, UUID> attackedPlayers = new HashMap<MageObjectReference, UUID>();
            for (UUID attackerId : game.getCombat().getAttackers()) {
                Permanent attacker = game.getPermanent(attackerId);
                if (attacker == null) continue;
                attackedPlayers.put(new MageObjectReference((MageObject)attacker, game), game.getCombat().getDefenderId(attackerId));
            }
            this.attackedLastCombatPlayers.put(game.getCombat().getAttackingPlayerId(), attackedPlayers);
        }
    }

    public Map<MageObjectReference, UUID> getAttackedLastCombatPlayers(UUID combatPlayerId) {
        return this.attackedLastCombatPlayers.get(combatPlayerId);
    }
}

