/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBeBlockedByAllTargetEffect;
import mage.cards.t.BlackGatePredicate;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPlayer;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class BlackGateEffect
extends OneShotEffect {
    private static final FilterPlayer filter = new FilterPlayer("player with the most life or tied for most life");

    BlackGateEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a player with the most life or tied for most life. Target creature can't be blocked by creatures that player controls this turn.";
    }

    private BlackGateEffect(BlackGateEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlackGateEffect copy() {
        return new BlackGateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (controller == null || creature == null) {
            return false;
        }
        TargetPlayer target = new TargetPlayer(filter);
        target.withNotTarget(true);
        if (!controller.choose(Outcome.Detriment, (Target)target, source, game)) {
            return false;
        }
        Player player = game.getPlayer(target.getFirstTarget());
        if (player == null) {
            return false;
        }
        game.informPlayers(controller.getLogName() + " chose " + player.getLogName() + CardUtil.getSourceLogName((Game)game, (Ability)source));
        FilterCreaturePermanent filterCantBlock = new FilterCreaturePermanent("creatures controlled by" + player.getName());
        filterCantBlock.add((Predicate)new ControllerIdPredicate(player.getId()));
        CantBeBlockedByAllTargetEffect effect = new CantBeBlockedByAllTargetEffect(filterCantBlock, Duration.EndOfTurn);
        effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)BlackGatePredicate.instance);
    }
}

