/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;

class BlocksTriggeredAbility
extends TriggeredAbilityImpl {
    public BlocksTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTriggerPhrase("Whenever one or more creatures block, ");
    }

    private BlocksTriggeredAbility(BlocksTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_BLOCKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        for (CombatGroup combatGroup : game.getCombat().getGroups()) {
            if (combatGroup.getBlockers().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BlocksTriggeredAbility copy() {
        return new BlocksTriggeredAbility(this);
    }
}

