/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;

class CantBeBlockedUnlessAllEffect
extends RestrictionEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public CantBeBlockedUnlessAllEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't be blocked unless all creatures defending player controls block it";
    }

    private CantBeBlockedUnlessAllEffect(CantBeBlockedUnlessAllEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, blocker.getControllerId(), game)) {
            if (permanent.isTapped() && game.getState().getContinuousEffects().asThough(this.getId(), AsThoughEffectType.BLOCK_TAPPED, null, blocker.getControllerId(), game).isEmpty()) {
                return false;
            }
            for (Map.Entry entry : game.getContinuousEffects().getApplicableRestrictionEffects(permanent, game).entrySet()) {
                for (Ability ability : (Set)entry.getValue()) {
                    if (((RestrictionEffect)entry.getKey()).canBlock(attacker, permanent, ability, game, canUseChooseDialogs)) continue;
                    return false;
                }
            }
            for (Map.Entry restrictionEntry : game.getContinuousEffects().getApplicableRestrictionEffects(attacker, game).entrySet()) {
                for (Ability ability : (Set)restrictionEntry.getValue()) {
                    if (restrictionEntry.getKey() instanceof CantBeBlockedUnlessAllEffect || ((RestrictionEffect)restrictionEntry.getKey()).canBeBlocked(attacker, permanent, ability, game, canUseChooseDialogs)) continue;
                    return false;
                }
            }
            if (!attacker.hasProtectionFrom((MageObject)permanent, game)) continue;
            return false;
        }
        return true;
    }

    public boolean canBeBlockedCheckAfter(Permanent attacker, Ability source, Game game, boolean canUseChooseDialogs) {
        for (CombatGroup combatGroup : game.getCombat().getGroups()) {
            if (!combatGroup.getAttackers().contains(source.getSourceId())) continue;
            for (UUID blockerId : combatGroup.getBlockers()) {
                Permanent blockingCreature = game.getPermanent(blockerId);
                if (blockingCreature == null) continue;
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, blockingCreature.getControllerId(), game)) {
                    if (combatGroup.getBlockers().contains(permanent.getId())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public CantBeBlockedUnlessAllEffect copy() {
        return new CantBeBlockedUnlessAllEffect(this);
    }
}

