/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.players.Player;

enum OnePlayerHasTheMostWizards implements Condition
{
    instance;

    private static final FilterPermanent filter;

    public boolean apply(Game game, Ability source) {
        return OnePlayerHasTheMostWizards.getPlayerWithMostWizards(game, source) != null;
    }

    public static Player getPlayerWithMostWizards(Game game, Ability source) {
        int max = Integer.MIN_VALUE;
        Player playerWithMost = null;
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            int wizards = game.getBattlefield().countAll(filter, playerId, game);
            if (wizards > max) {
                max = wizards;
                playerWithMost = player;
                continue;
            }
            if (wizards != max) continue;
            playerWithMost = null;
        }
        return playerWithMost;
    }

    public String toString() {
        return "a player controls more Wizards than each other player";
    }

    static {
        filter = new FilterPermanent(SubType.WIZARD, "Wizards");
    }
}

