/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ReturnSourceFromExileToBattlefieldEffect
extends OneShotEffect {
    private boolean tapped;
    private boolean ownerControl;

    public ReturnSourceFromExileToBattlefieldEffect() {
        this(false);
    }

    public ReturnSourceFromExileToBattlefieldEffect(boolean tapped) {
        super(Outcome.PutCreatureInPlay);
        this.tapped = tapped;
        this.setText();
    }

    public ReturnSourceFromExileToBattlefieldEffect(boolean tapped, boolean ownerControl) {
        super(Outcome.PutCreatureInPlay);
        this.tapped = tapped;
        this.ownerControl = ownerControl;
        this.setText();
    }

    private ReturnSourceFromExileToBattlefieldEffect(ReturnSourceFromExileToBattlefieldEffect effect) {
        super((OneShotEffect)effect);
        this.tapped = effect.tapped;
        this.ownerControl = effect.ownerControl;
    }

    public ReturnSourceFromExileToBattlefieldEffect copy() {
        return new ReturnSourceFromExileToBattlefieldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (game.getState().getZone(source.getSourceId()) != Zone.EXILED) {
            return false;
        }
        Card card = game.getCard(source.getSourceId());
        if (card == null) {
            return false;
        }
        Player player = this.ownerControl ? game.getPlayer(card.getOwnerId()) : game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        return player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
    }

    private void setText() {
        StringBuilder sb = new StringBuilder("Put {this} from exile onto the battlefield");
        if (this.tapped) {
            sb.append(" tapped");
        }
        if (this.ownerControl) {
            sb.append(" under its owner's control");
        }
        this.staticText = sb.toString();
    }
}

