/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TIESilencerEffect
extends OneShotEffect {
    TIESilencerEffect() {
        super(Outcome.Damage);
        this.staticText = "it deals 1 damage to defending player and 1 damage to up to one target creature that player controls";
    }

    private TIESilencerEffect(TIESilencerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        UUID defender = game.getCombat().getDefendingPlayerId(source.getSourceId(), game);
        if (defender != null) {
            game.damagePlayerOrPermanent(defender, 1, source.getSourceId(), source, game, false, true);
            UUID target = source.getTargets().getFirstTarget();
            Permanent permanent = game.getPermanent(target);
            if (permanent != null) {
                permanent.damage(1, source.getSourceId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }

    public TIESilencerEffect copy() {
        return new TIESilencerEffect(this);
    }
}

