/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.effects.keyword.ScryEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class TaekoThePatientAvalancheTriggeredAbility
extends TriggeredAbilityImpl {
    TaekoThePatientAvalancheTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ScryEffect(1, false));
        this.addEffect((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()).concatBy("and"));
        this.setTriggerPhrase("Whenever another creature you control leaves the battlefield, if it didn't die, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private TaekoThePatientAvalancheTriggeredAbility(TaekoThePatientAvalancheTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TaekoThePatientAvalancheTriggeredAbility copy() {
        return new TaekoThePatientAvalancheTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!Zone.BATTLEFIELD.match(zEvent.getFromZone()) || Zone.GRAVEYARD.match(zEvent.getToZone())) {
            return false;
        }
        Permanent permanent = zEvent.getTarget();
        return permanent != null && !permanent.getId().equals(this.getSourceId()) && permanent.isControlledBy(this.getControllerId()) && permanent.isCreature(game);
    }
}

