/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class TaiiWakeenPerfectShotEffect
extends ReplacementEffectImpl {
    TaiiWakeenPerfectShotEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "if a source you control would deal noncombat damage to a permanent or player this turn, it deals that much damage plus X instead";
    }

    private TaiiWakeenPerfectShotEffect(TaiiWakeenPerfectShotEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return !((DamageEvent)event).isCombatDamage() && source.isControlledBy(game.getControllerId(event.getSourceId()));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0))));
        return false;
    }

    public TaiiWakeenPerfectShotEffect copy() {
        return new TaiiWakeenPerfectShotEffect(this);
    }
}

