/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.ZombieDecayedToken;

class TaintedAdversaryEffect
extends OneShotEffect {
    TaintedAdversaryEffect() {
        super(Outcome.Benefit);
        this.staticText = "put that many +1/+1 counters on {this}, then create twice that many 2/2 black Zombie creature tokens with decayed";
    }

    private TaintedAdversaryEffect(TaintedAdversaryEffect effect) {
        super((OneShotEffect)effect);
    }

    public TaintedAdversaryEffect copy() {
        return new TaintedAdversaryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Integer timesPaid = (Integer)this.getValue("timesPaid");
        if (timesPaid == null || timesPaid <= 0) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance(timesPaid.intValue())), false, this.staticText);
        ability.addEffect((Effect)new CreateTokenEffect((Token)new ZombieDecayedToken(), 2 * timesPaid));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

