/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TaintedPactEffect
extends OneShotEffect {
    TaintedPactEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Exile the top card of your library. You may put that card into your hand unless it has the same name as another card exiled this way. Repeat this process until you put a card into your hand or you exile two cards with the same name, whichever comes first";
    }

    private TaintedPactEffect(TaintedPactEffect effect) {
        super((OneShotEffect)effect);
    }

    public TaintedPactEffect copy() {
        return new TaintedPactEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card sourceCard = game.getCard(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || sourceCard == null) {
            return false;
        }
        HashSet<String> names = new HashSet<String>();
        while (controller.canRespond() && controller.getLibrary().hasCards()) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card == null) continue;
            controller.moveCards(card, Zone.EXILED, source, game);
            game.processAction();
            if (names.contains(card.getName())) break;
            names.add(card.getName());
            if (!controller.chooseUse(this.outcome, "Put " + card.getName() + " into your hand?", source, game)) continue;
            controller.moveCards(card, Zone.HAND, source, game);
            break;
        }
        return true;
    }
}

