/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.SharesCreatureTypePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class TajuruParagonEffect
extends OneShotEffect {
    TajuruParagonEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top six cards of your library. You may put a card that shares a creature type with it from among them into your hand. Put the rest on the bottom of your library in a random order";
    }

    private TajuruParagonEffect(TajuruParagonEffect effect) {
        super((OneShotEffect)effect);
    }

    public TajuruParagonEffect copy() {
        return new TajuruParagonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 6));
        player.revealCards(source, (Cards)cards, game);
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent != null) {
            FilterCard filter = new FilterCard("card that shares a creature type with " + permanent.getName());
            filter.add((Predicate)new SharesCreatureTypePredicate(permanent));
            TargetCardInLibrary target = new TargetCardInLibrary(0, 1, filter);
            player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
            Card card = game.getCard(target.getFirstTarget());
            if (card != null) {
                player.moveCardToHandWithInfo(card, source, game, true);
                cards.remove(card);
            }
        }
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

