/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.players.Player;

class TakenumaBleederEffect
extends OneShotEffect {
    public TakenumaBleederEffect() {
        super(Outcome.LoseLife);
        this.staticText = "you lose 1 life if you don't control a Demon";
    }

    private TakenumaBleederEffect(TakenumaBleederEffect effect) {
        super((OneShotEffect)effect);
    }

    public TakenumaBleederEffect copy() {
        return new TakenumaBleederEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (game.getBattlefield().countAll((FilterPermanent)new FilterCreaturePermanent(SubType.DEMON, "Demon"), source.getControllerId(), game) < 1) {
                controller.loseLife(1, game, source, false);
            }
            return true;
        }
        return false;
    }
}

