/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class TalarasBaneEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("a green or white creature card");

    public TalarasBaneEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target opponent reveals their hand. You choose a green or white creature card from it. You gain life equal to that creature card's toughness, then that player discards that card";
    }

    private TalarasBaneEffect(TalarasBaneEffect effect) {
        super((OneShotEffect)effect);
    }

    public TalarasBaneEffect copy() {
        return new TalarasBaneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        Player you = game.getPlayer(source.getControllerId());
        Card card = null;
        if (targetPlayer != null && you != null) {
            targetPlayer.revealCards("Talaras Bane", targetPlayer.getHand(), game);
            TargetCard target = new TargetCard(Zone.HAND, filter);
            if (you.choose(Outcome.Benefit, targetPlayer.getHand(), target, source, game)) {
                card = targetPlayer.getHand().get(target.getFirstTarget(), game);
            }
            if (card != null) {
                int lifeGain = card.getToughness().getValue();
                you.gainLife(lifeGain, game, source);
                return targetPlayer.discard(card, false, source, game);
            }
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate)new ColorPredicate(ObjectColor.GREEN), (Predicate)new ColorPredicate(ObjectColor.WHITE)));
        filter.add((Predicate)CardType.CREATURE.getPredicate());
    }
}

