/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TalesOfTheAncestorsEffect
extends OneShotEffect {
    TalesOfTheAncestorsEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player with fewer cards in hand than the player with the most cards in hand draws cards equal to the difference";
    }

    private TalesOfTheAncestorsEffect(TalesOfTheAncestorsEffect effect) {
        super((OneShotEffect)effect);
    }

    public TalesOfTheAncestorsEffect copy() {
        return new TalesOfTheAncestorsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        int cardCount = 0;
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            cardCount = Math.max(cardCount, player.getHand().size());
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            int diff;
            player = game.getPlayer(playerId);
            if (player == null || (diff = cardCount - player.getHand().size()) <= 0) continue;
            player.drawCards(diff, source, game);
        }
        return true;
    }
}

