/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilityAllEffect;
import mage.abilities.keyword.LifelinkAbility;
import mage.cards.t.TalusPaladinEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TalusPaladinTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("all allies you control");

    TalusPaladinTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainAbilityAllEffect((Ability)LifelinkAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filter), true);
        this.addEffect((Effect)new TalusPaladinEffect());
    }

    private TalusPaladinTriggeredAbility(TalusPaladinTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TalusPaladinTriggeredAbility copy() {
        return new TalusPaladinTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent ally = game.getPermanent(event.getTargetId());
        return ally != null && ally.hasSubtype(SubType.ALLY, game) && ally.isControlledBy(this.getControllerId()) && (event.getTargetId().equals(this.getSourceId()) || event.getTargetId().equals(ally.getId()));
    }

    public String getRule() {
        return "Whenever {this} or another Ally you control enters, you may have Allies you control gain lifelink until end of turn, and you may put a +1/+1 counter on {this}.";
    }

    static {
        filter.add((Predicate)SubType.ALLY.getPredicate());
    }
}

