/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TamiyoCollectorOfTalesRuleEffect
extends ContinuousRuleModifyingEffectImpl {
    TamiyoCollectorOfTalesRuleEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Spells and abilities your opponents control can't cause you to discard cards or sacrifice permanents";
    }

    private TamiyoCollectorOfTalesRuleEffect(TamiyoCollectorOfTalesRuleEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public TamiyoCollectorOfTalesRuleEffect copy() {
        return new TamiyoCollectorOfTalesRuleEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SACRIFICE_PERMANENT || event.getType() == GameEvent.EventType.DISCARD_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        UUID eventSourceControllerId = game.getControllerId(event.getSourceId());
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (controller != null && permanent != null && permanent.getControllerId() == source.getControllerId()) {
            return game.getOpponents(source.getControllerId()).contains(eventSourceControllerId);
        }
        Card cardInHand = game.getCard(event.getTargetId());
        if (controller != null && cardInHand != null && cardInHand.getOwnerId() == source.getControllerId()) {
            return game.getOpponents(source.getControllerId()).contains(eventSourceControllerId);
        }
        return false;
    }
}

