/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.t.TanukiTransplanterEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TanukiTransplanterTriggeredAbility
extends TriggeredAbilityImpl {
    TanukiTransplanterTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TanukiTransplanterEffect());
    }

    private TanukiTransplanterTriggeredAbility(TanukiTransplanterTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TanukiTransplanterTriggeredAbility copy() {
        return new TanukiTransplanterTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        UUID attacker = !game.getCombat().getAttackers().contains(this.getSourceId()) ? ((permanent = this.getSourcePermanentOrLKI(game)) != null && game.getCombat().getAttackers().contains(permanent.getAttachedTo()) ? permanent.getAttachedTo() : null) : this.getSourceId();
        if (attacker == null) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(attacker, game));
        return true;
    }

    public String getRule() {
        return "Whenever {this} or equipped creature attacks, add an amount of {G} equal to its power. Until end of turn, you don't lose this mana as steps and phases end.";
    }
}

