/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TavernSwindlerEffect
extends OneShotEffect {
    TavernSwindlerEffect() {
        super(Outcome.Damage);
        this.staticText = "Flip a coin. If you win the flip, you gain 6 life";
    }

    private TavernSwindlerEffect(TavernSwindlerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.flipCoin(source, game, true)) {
            game.informPlayers(controller.getLogName() + " got " + controller.gainLife(6, game, source) + " live");
        }
        return false;
    }

    public TavernSwindlerEffect copy() {
        return new TavernSwindlerEffect(this);
    }
}

