/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class TayamLuminousEnigmaEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterPermanentCard("permanent card in your graveyard with mana value 3 or less");

    TayamLuminousEnigmaEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then return a permanent card with mana value 3 or less from your graveyard to the battlefield";
    }

    private TayamLuminousEnigmaEffect(TayamLuminousEnigmaEffect effect) {
        super((OneShotEffect)effect);
    }

    public TayamLuminousEnigmaEffect copy() {
        return new TayamLuminousEnigmaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getGraveyard().count(filter, game) == 0) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(filter);
        target.withNotTarget(true);
        if (!player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game)) {
            return false;
        }
        return player.moveCards(game.getCard(target.getFirstTarget()), Zone.BATTLEFIELD, source, game);
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 4));
    }
}

