/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingCreature;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class TearsOfRageEffect
extends OneShotEffect {
    TearsOfRageEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Sacrifice those creatures at the beginning of the next end step";
    }

    private TearsOfRageEffect(TearsOfRageEffect effect) {
        super((OneShotEffect)effect);
    }

    public TearsOfRageEffect copy() {
        return new TearsOfRageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            SacrificeTargetEffect effect = new SacrificeTargetEffect("Sacrifice those creatures at the beginning of the next end step", source.getControllerId());
            effect.setTargetPointer((TargetPointer)new FixedTargets((Collection)game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterAttackingCreature(), controller.getId(), game), game));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect), source);
            return true;
        }
        return false;
    }
}

