/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.CyclingAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class TectonicReformationEffect
extends ContinuousEffectImpl {
    TectonicReformationEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "each land card in your hand has cycling {R}";
    }

    private TectonicReformationEffect(TectonicReformationEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TectonicReformationEffect copy() {
        return new TectonicReformationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (Card card : controller.getHand().getCards((FilterCard)StaticFilters.FILTER_CARD_LAND, game)) {
            game.getState().addOtherAbility(card, (Ability)new CyclingAbility((Cost)new ManaCostsImpl("{R}")));
        }
        return true;
    }
}

