/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class TeferiMageOfZhalfirReplacementEffect
extends ContinuousRuleModifyingEffectImpl {
    TeferiMageOfZhalfirReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Each opponent can cast spells only any time they could cast a sorcery";
    }

    private TeferiMageOfZhalfirReplacementEffect(TeferiMageOfZhalfirReplacementEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can cast spells only any time you could cast a sorcery  (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.hasOpponent(event.getPlayerId(), game)) {
            return !game.canPlaySorcery(event.getPlayerId());
        }
        return false;
    }

    public TeferiMageOfZhalfirReplacementEffect copy() {
        return new TeferiMageOfZhalfirReplacementEffect(this);
    }
}

