/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.t.TeferiTimelessVoyagerPhaseEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TeferiTimelessVoyagerEffect
extends OneShotEffect {
    TeferiTimelessVoyagerEffect() {
        super(Outcome.Benefit);
        this.staticText = "each creature target opponent controls phases out. Until the end of your next turn, they can't phase in";
    }

    private TeferiTimelessVoyagerEffect(TeferiTimelessVoyagerEffect effect) {
        super((OneShotEffect)effect);
    }

    public TeferiTimelessVoyagerEffect copy() {
        return new TeferiTimelessVoyagerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getFirstTarget(), game)) {
            MageObjectReference mor = new MageObjectReference((MageObject)permanent, game);
            permanent.phaseOut(game);
            game.addEffect((ContinuousEffect)new TeferiTimelessVoyagerPhaseEffect(mor), source);
        }
        return true;
    }
}

