/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class TekuthalInquiryDominusEffect
extends ReplacementEffectImpl {
    TekuthalInquiryDominusEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would proliferate, proliferate twice instead.";
    }

    private TekuthalInquiryDominusEffect(TekuthalInquiryDominusEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TekuthalInquiryDominusEffect copy() {
        return new TekuthalInquiryDominusEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PROLIFERATE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

